#Supercars program
#Example solution using Parallel Arrays
#Programmed by Mr A Simpson
#Date: 10/11/2022
# ---------------------------------------------

# 3 Read pupil details from file
def readFromFile(name,topSpeed,engineSize,bhp):
    counter = 0

    with open("Supercars.csv") as readfile:
        line = readfile.readline().rstrip("\n")
        while line:
            items = line.split(",")
            name[counter]= items[0]
            topSpeed[counter] = int(items[1])
            engineSize[counter] = float(items[2])
            bhp[counter] = int(items[3])

            line = readfile.readline().rstrip("\n")

            counter += 1


# -------------------------------------------

# 2. Find the Supercar with the fastest topSpeed.
def findMaxCar(name,topSpeed,fastestCar, fastestSpeed):
    #initialise local variables
    maximum = 0
    maxPos = 0

    #set first position of list to maximum
    maximum = topSpeed[0]

    #loop through each position from second item
    for counter in range(1, len(name)):
        if topSpeed[counter] > maximum:
            maximum = topSpeed[counter]
            maxPos = counter
    fastestCar = name[maxPos]
    fastestSpeed = maximum

    return fastestCar, fastestSpeed


# -----------------------------------------------
# 3 Count the number of Supercars with a brake horse power (BHP) > 600 inclusive
def countOccurences(bhp, noOfBHP):

    for counter in range(0, len(bhp)):
        if bhp[counter] > 600:
            noOfBHP += 1
    return noOfBHP

# ---------------------------------------------

# 4. Allow the user to search for a car name and return engine size. Use LAFerrari to test.
def linearSearch(name,engineSize):
    found = False
    target = ""
    
    print("-----Engine Size Checker ------")
    target = input("What car would you like to search for?")
    for counter in range(0,len(name)):
        if name[counter] == target:
            found = True
            position = counter

    if found == True:
        print(target, "has an engine size of", engineSize[position])
    else:
        print("Car was not found")
# ---------------------------------------------

# 8 Display results to Screen
def DisplayResults(fastestCar, fastestSpeed, noOfBHP):

    print("-----------------------------------------")
    print("The fastest car is the ", fastestCar, "with a top speed of", fastestSpeed)
    print("The number of cars over 600 BHP is ", noOfBHP)

# -----------------------------------------------
# Main Program

#Create Parallel Arrays & declare variables

name= [""]* 29
topSpeed =  [0]* 29
engineSize =[0.0]* 29
bhp = [0]* 29


fastestCar = ""
fastestSpeed = 0
noOfBHP = 0

#------- Call functions/subprograms and pass parameters -------------

# 1. Call funtion to read in and store values from SuperCars.csv
readFromFile(name,topSpeed,engineSize,bhp)

# 2. Find the Supercar with the fastest topSpeed.
fastestCar,fastestSpeed = findMaxCar(name,topSpeed,fastestCar, fastestSpeed)

# 3. Count the number of Supercars with a brake horse power (BHP) > 600 inclusive
noOfBHP = countOccurences(bhp, noOfBHP)

# 4. Allow the user to search for a car name and return engine size. 
#    Use LAFerrari to test (case sensitive)
searchEngine = linearSearch(name,engineSize)

# 5. Display results to screen
DisplayResults(fastestCar, fastestSpeed, noOfBHP)



